Scriptname _SLSubmitGuardEffect extends ActiveMagicEffect  

Spell Property _SLSubmitGuard  Auto  
Spell Property _SLSubmitHelp  Auto  
MagicEffect Property _SLSubmitHelpEffect  Auto  
SexLabFramework Property SexLab  Auto  
Actor Property PlayerRef Auto

Event OnEffectStart(actor Target, actor Caster)
	sslThreadController Thread = SexLab.GetPlayerController()
	If (Target.IsGuard() && Target.HasLOS(PlayerRef))
		debug.Notification(Target.GetBaseObject().GetName() + " saw you!")
		If (Thread != None && Thread.GetState() == "Animating")
			Thread.EndAnimation(True)
		EndIf
		Target.SendAssaultAlarm()
		Target.startCombat(Caster)
		If (Caster.HasSpell(_SLSubmitGuard))
			Caster.RemoveSpell(_SLSubmitGuard)
		ElseIf (Caster.HasMagicEffect(_SLSubmitHelpEffect))
			Caster.DispelSpell(_SLSubmitHelp)
		EndIf
	EndIf
EndEvent
